/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.particles;

import com.alexander.mutantmore.particles.EntityTrackingParticleOption;
import com.alexander.mutantmore.util.PositionUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RodlingChargeShotParticle<T extends EntityTrackingParticleOption>
extends TextureSheetParticle {
    private int followedEntityID;
    private double offsetXPosition;
    private double offsetYPosition;
    private double offsetZPosition;
    private Vec3 targetPos;

    protected RodlingChargeShotParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, T particleOptions) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.followedEntityID = ((EntityTrackingParticleOption)particleOptions).followedEntityID;
        this.offsetXPosition = ((EntityTrackingParticleOption)particleOptions).offsetXPosition;
        this.offsetYPosition = ((EntityTrackingParticleOption)particleOptions).offsetYPosition;
        this.offsetZPosition = ((EntityTrackingParticleOption)particleOptions).offsetZPosition;
        this.f_172258_ = 1.0f;
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107663_ = 0.75f;
        this.f_107225_ = 500;
        this.f_107230_ = 0.0f;
        this.m_108335_(spriteSet);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.targetPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107212_ = this.targetPos.f_82479_;
        this.f_107213_ = this.targetPos.f_82480_;
        this.f_107214_ = this.targetPos.f_82481_;
        this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.followedEntityID != 0 && this.f_107208_.m_6815_(this.followedEntityID) != null) {
            Vec3 newPos;
            Entity entity = this.f_107208_.m_6815_(this.followedEntityID);
            float rotation = entity instanceof LivingEntity ? ((LivingEntity)entity).f_20883_ : entity.m_146908_();
            this.targetPos = newPos = PositionUtils.getOffsetPos(entity, this.offsetXPosition, this.offsetYPosition, this.offsetZPosition, rotation);
        }
        this.f_107663_ -= 0.075f;
        if (this.f_107663_ <= 0.0f) {
            this.m_107274_();
        }
        if (this.f_107230_ < 1.0f) {
            this.f_107230_ = this.f_107230_ + 0.25f > 1.0f ? 1.0f : (this.f_107230_ += 0.25f);
        }
    }

    public int m_6355_(float p_106821_) {
        return 240;
    }

    private void fadeOut() {
        this.f_107230_ = -(1.0f / (float)this.f_107225_) * (float)this.f_107224_ + 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<EntityTrackingParticleOption> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(EntityTrackingParticleOption particleOptions, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new RodlingChargeShotParticle<EntityTrackingParticleOption>(level, x, y, z, this.sprites, dx, dy, dz, particleOptions);
        }
    }
}

